<?php

/**
 * @package     Joomla.Plugin
 * @subpackage  Quickicon.customquickicon
 *
 * @copyright   Copyright (c) 2024 Petitpoisson (Xavier Spirlet). All rights reserved
 * @license     GNU/GPL 3 or later - http://www.gnu.org/licenses/old-licenses/gpl-3.0.html
 */

namespace Joomla\Plugin\Quickicon\Customquickicon\Extension;

use Joomla\CMS\Date\Date;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\Event\SubscriberInterface;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\Module\Quickicon\Administrator\Event\QuickIconsEvent;

\defined('_JEXEC') or die;

final class Customquickicon extends CMSPlugin implements SubscriberInterface
{
    /**
     * Load plugin language files automatically
     *
     * @var    boolean
     * @since  3.9.0
     */
    protected $autoloadLanguage = true;

    /**
     * Returns an array of events this subscriber will listen to.
     *
     * @return  array
     *
     * @since   4.3.0
     */
    public static function getSubscribedEvents(): array
    {
        return [
            'onGetIcons' => 'onGetIcons',
        ];
    }

    public function onGetIcons(QuickIconsEvent $event): void
    {
        $context = $event->getContext();

        if ($context != $this->params->get('context', 'mod_quickicon')) {
            return;
        }

        // Add the icon to the result array
        $result = $event->getArgument('result', []);

        $result[] = [
            [
            'link'      => $this->params->get("dest_url"),
            'image'     => $this->params->get("button_class"),
            'text'      => $this->params->get("button_text"),
            'id'        => 'plg_quickicon_customquickicon'
            ],
        ];

        $event->setArgument('result', $result);
    }
}
