<?php

/**
 * @package     Joomla.Plugin
 * @subpackage  Quickicon.Customquickicon
 *
 * @copyright   (C) 2024 Petitpoisson. <https://www.petitpoisson.be>
 * @license     GNU General Public License version 3 or later
 */

\defined('_JEXEC') or die;

use Joomla\CMS\Extension\PluginInterface;
use Joomla\CMS\Factory;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\Database\DatabaseInterface;
use Joomla\DI\Container;
use Joomla\DI\ServiceProviderInterface;
use Joomla\Event\DispatcherInterface;
use Joomla\Plugin\Quickicon\Customquickicon\Extension\Customquickicon;

return new class () implements ServiceProviderInterface {
    /**
     * Registers the service provider with a DI container.
     *
     * @param   Container  $container  The DI container.
     *
     * @return  void
     *
     * @since  4.4.0
     *
     * @throws Exception
     */
    public function register(Container $container)
    {
        $container->set(
            PluginInterface::class,
            function (Container $container) {
                $pluginParams = (array) PluginHelper::getPlugin('quickicon', 'customquickicon');
                @ $plugin     = new Customquickicon(
                    $container->get(DispatcherInterface::class),
                    (array) PluginHelper::getPlugin('quickicon', 'customquickicon')
                );
                $plugin->setApplication(Factory::getApplication());

                return $plugin;
            }
        );
    }
};